#include "stdinc.h"
#include "main.h"
#include "pg.h"
#include "string.h"
#include "filer.h"
#include "hue_fio.h"
#include "hue_image.h"

// global
EmuConfig eConf= {

    EMUCONFIG,    // magic number
    0,            // cpu clock
    1,            // vsync wait
    0,            // 6 button
    1,            // sound [off/stereo/mono]
    0x00,         // frame skip timing
    // key config
    {   1 ,       // cross
        0 ,       // circle
        1 ,       // square
        0 ,       // triangle
        1 ,       // L trigger
        0  },     // R trigger
    0,            // debug
    // rapid
    {   0,        // cross
        0,        // circle
        1,        // square
        1,        // triangle
        0,        // L trigger
        0  },     // R trigger
    0,            // pad number
    "",           // cdrom name
    0,            // video
}, pConf;


typedef struct {
    char menu[128];
    char data[128];
    char **msg;
} MENU_STRUCT;


static char *msgOnOff[2]={"Off","On"};
static char *msgClock[3]={"333MHz","266MHz","222MHz"};
static char *msgVideo[16]={"cpu","gpu","gpu 4:3","gpu(full)"};
static char *msgPadNo[5]={ "Player 1", "Player 2", "Player 3", "Player 4", "Player 5" };
static char *msgKey  [6]={"Joy A","Joy B","Joy C","Joy D","Joy E","Joy F"};

// 
static MENU_STRUCT psp_menu[] = {
#define    MENU_CPUCLOCK 0
    {"CPU Clock"             ,"", &msgClock },
#define MENU_VSYNC       1
    {"Vsync Wait"            ,"", &msgOnOff },
#define MENU_VIDEO       2
    {"video"                 ,"", &msgVideo },
#define    MENU_PADNO    3
    {"Control Pad No"        ,"", &msgPadNo },
#define    MENU_6BUTTON  4
    {"6 Button"              ,"", &msgOnOff },
#define    MENU_KEY1     5
    {"key : ~"              ,"", &msgKey   },
#define    MENU_KEY2     6
    {"key : "              ,"", &msgKey   },
#define    MENU_KEY3     7
    {"key : "              ,"", &msgKey   },
#define    MENU_KEY4     8
    {"key : "              ,"", &msgKey   },
#define    MENU_KEY5     9 
    {"key : L-trigger"       ,"", &msgKey   },
#define    MENU_KEY6    10
    {"key : R-trigger"       ,"", &msgKey   },
#define    MENU_SOUND   11
    {"sound"                 ,"", &msgOnOff },
#define    MENU_SKIP    12
    {"frameskip mapping"     ,"", 0},
#define    MENU_DEBUG   13
    {"debug"                 ,"", &msgOnOff},
#define    MENU_SAVE    14
    {"state save"            ,"", 0},
#define    MENU_LOAD    15
    {"state load"            ,"", 0},
#define    MENU_ROM     16
    {"rom select"            ,"ROM select",0},
#define    MENU_QUIT    17
    {"exit"                  ,"Quit HuE for PSP",0},
#define    MENU_CONT    18
    {"continue"              ,"back to game",0},

#define MENU_STRING     19
};

static char *msgSkip[16]={"","","","",
                   ""                ,""                ,"","",
                   ""                ,""                ,"",""                ,
                   ""                ,""                ,"",""};
static char *msgRapid[8]={
    " [rapid off]",
    " [> > > > >]",
    " [>  >  >  ]",
    " [>   >   >]",
    " [>    >   ]",
    " [>     >  ]",
    " [>      > ]",
    " [>       >]"
};

// őŏŎ~߂
static int _round(int cur, int change,int min, int max)
{
    cur+=change;
    if(cur<min) { cur=min; }
    if(cur>max) { cur=max; }
    return cur;
}

// őŏŔΑւ
static int _loop(int cur, int change,int min, int max)
{
    cur+=change;
    if(cur<min) { cur=max; }
    if(cur>max) { cur=min; }
    return cur;
}


//--------------------------------------------------------------------------
// draw menu
// ܂ʓ|ȏ͂Ȃ̂ŃeLg[ɁB
// 
//--------------------------------------------------------------------------
DWORD menu_Main(void)
{
    int st_num=0;
    int select=0,val;
    int i,sx,sy;
    DWORD retcode = STATE_PLAY;
    int load=0,save=0;
    EmuConfig inConf;
    int romflag=0;

    
    // obNAbvƂB
    _memcpy(&inConf,&eConf,sizeof(EmuConfig));

    // ʂ^ɂ
    CLS(0);

    clockDown();

#ifdef SOUND
    enable_sound(0);
#endif
    
    while(1) {
        readpad();
        pgFillvram(0);

        sx = 30;
        sy = 30;
        val=0;
        if(new_pad & CTRL_UP  )  { select--; }
        if(new_pad & CTRL_DOWN)  { select++; }
        if(new_pad & CTRL_START) { retcode=STATE_CONT; break; }

        if(select<0) select=MENU_STRING-1;
        if(select==MENU_STRING) select=0;

        if((now_pad & CTRL_RTRIGGER)) {
            _strcpy(psp_menu[MENU_ROM].menu,"toc select");
            _strcpy(psp_menu[MENU_ROM].data,eConf.cdrom);
            romflag=1;
        } else {
            _strcpy(psp_menu[MENU_ROM].menu,"rom select");
            _strcpy(psp_menu[MENU_ROM].data,"");
            romflag=0;
        }

        // 
        if(new_pad & (CTRL_CIRCLE|CTRL_CROSS)){
            int change=-1;
            if(new_pad&CTRL_CIRCLE) change=1;

            if(select==MENU_CPUCLOCK)  eConf.clock  = _loop(eConf.clock,change,0,2);
            if(select==MENU_VSYNC   )  eConf.vsync  = _loop(eConf.vsync,change,0,1);
            if(select==MENU_VIDEO   )  eConf.video  = _loop(eConf.video,change,0,3);
            if(select==MENU_PADNO   )  eConf.padno  = _loop(eConf.padno,change,0,4);
            if(select==MENU_6BUTTON )  eConf.button6= _loop(eConf.button6,change,0,1);
            if(select==MENU_SOUND   )  eConf.sound  = _loop(eConf.sound,change,0,1);
            if(select==MENU_SKIP    )  eConf.skip   = ((eConf.skip&0x0f)==0)?0x0f:(eConf.skip>>1);
            if(select==MENU_DEBUG   )  eConf.debug  = 1-eConf.debug;

            if(select==MENU_KEY1    )  eConf.key[0] = _loop(eConf.key[0],change,0,5);
            if(select==MENU_KEY2    )  eConf.key[1] = _loop(eConf.key[1],change,0,5);
            if(select==MENU_KEY3    )  eConf.key[2] = _loop(eConf.key[2],change,0,5);
            if(select==MENU_KEY4    )  eConf.key[3] = _loop(eConf.key[3],change,0,5);
            if(select==MENU_KEY5    )  eConf.key[4] = _loop(eConf.key[4],change,0,5);
            if(select==MENU_KEY6    )  eConf.key[5] = _loop(eConf.key[5],change,0,5);

            if(select==MENU_SAVE    )  save = SaveState(st_num);
            
            if(select==MENU_LOAD    ){
                if(LoadState(st_num)==1) {
                    retcode=STATE_CONT;
                    ClearImage();
                    break;
                }
            }
            
            if(select==MENU_CONT    ){ retcode=STATE_CONT; break; }

            if(select==MENU_ROM){
                if(romflag==0) {
                    retcode=STATE_ROM;
                    break;
                }
                else {
                    int ext[2]={EXT_TOC,EXT_NULL};
                    getFilePath(eConf.cdrom,eRun.hue_path,ext);
                }
            }
            if(select==MENU_QUIT    ){ retcode=STATE_QUIT; break; }
        }

        if(new_pad & (CTRL_LEFT|CTRL_RIGHT)) {
            int change=-1;
            if(new_pad&CTRL_RIGHT) change=1;
            if(select==MENU_KEY1)  eConf.rapid[0] = _loop(eConf.rapid[0],change,0,7); 
            if(select==MENU_KEY2)  eConf.rapid[1] = _loop(eConf.rapid[1],change,0,7); 
            if(select==MENU_KEY3)  eConf.rapid[2] = _loop(eConf.rapid[2],change,0,7); 
            if(select==MENU_KEY4)  eConf.rapid[3] = _loop(eConf.rapid[3],change,0,7); 
            if(select==MENU_KEY5)  eConf.rapid[4] = _loop(eConf.rapid[4],change,0,7); 
            if(select==MENU_KEY6)  eConf.rapid[5] = _loop(eConf.rapid[5],change,0,7); 

            if(select==MENU_SAVE)  st_num = _loop(st_num,change,0,9);
            if(select==MENU_LOAD)  st_num = _loop(st_num,change,0,9);
        }

        _strcpy(psp_menu[MENU_CPUCLOCK].data,psp_menu[MENU_CPUCLOCK].msg[eConf.clock]  );
        _strcpy(psp_menu[MENU_VSYNC   ].data,msgOnOff[eConf.vsync]  );
        _strcpy(psp_menu[MENU_VIDEO   ].data,psp_menu[MENU_VIDEO].msg[eConf.video]);
        _strcpy(psp_menu[MENU_PADNO   ].data,msgPadNo[eConf.padno]  );
        _strcpy(psp_menu[MENU_6BUTTON ].data,msgOnOff[eConf.button6]);
        _strcpy(psp_menu[MENU_SOUND   ].data,msgOnOff[eConf.sound]  );
        _strcpy(psp_menu[MENU_SKIP    ].data,msgSkip [eConf.skip]   );
        _strcpy(psp_menu[MENU_DEBUG   ].data,msgOnOff[eConf.debug]  );

        _strcpy(psp_menu[MENU_KEY1].data,msgKey[eConf.key[0]]);
        _strcpy(psp_menu[MENU_KEY2].data,msgKey[eConf.key[1]]);
        _strcpy(psp_menu[MENU_KEY3].data,msgKey[eConf.key[2]]);
        _strcpy(psp_menu[MENU_KEY4].data,msgKey[eConf.key[3]]);
        _strcpy(psp_menu[MENU_KEY5].data,msgKey[eConf.key[4]]);
        _strcpy(psp_menu[MENU_KEY6].data,msgKey[eConf.key[5]]);

        _strcat(psp_menu[MENU_KEY1].data,msgRapid[eConf.rapid[0]]);
        _strcat(psp_menu[MENU_KEY2].data,msgRapid[eConf.rapid[1]]);
        _strcat(psp_menu[MENU_KEY3].data,msgRapid[eConf.rapid[2]]);
        _strcat(psp_menu[MENU_KEY4].data,msgRapid[eConf.rapid[3]]);
        _strcat(psp_menu[MENU_KEY5].data,msgRapid[eConf.rapid[4]]);
        _strcat(psp_menu[MENU_KEY6].data,msgRapid[eConf.rapid[5]]);

        _strcpy(psp_menu[MENU_SAVE].data,"sav "); if(st_num>0) psp_menu[MENU_SAVE].data[2] = 0x30+st_num;
        _strcpy(psp_menu[MENU_LOAD].data,"sav "); if(st_num>0) psp_menu[MENU_LOAD].data[2] = 0x30+st_num;
        _strcat(psp_menu[MENU_SAVE].data,(save==1)?"save":(save==-1)?"Failed":"" );
        _strcat(psp_menu[MENU_LOAD].data,(load==1)?"load":(load==-1)?"Failed":"" );

        for(i=0;i<MENU_STRING;i++) {
            if(i==select)  mh_print(sx-10 ,sy,"",RGB_WHITE);
            mh_print(sx    ,sy,psp_menu[i].menu,(i==select)?RGB_RED:RGB_WHITE);
            mh_print(sx+100,sy,psp_menu[i].data,RGB_WHITE);
            sy += 10;
        }

        pgScreenFlipV();
        if(psp_ExitCheck()) { retcode=STATE_QUIT; break; }
    }

    /* IƂɕۑ邱Ƃɂ
    // ωۑ
    if(_memcmp(&inConf,&eConf,sizeof(EmuConfig))!=0) {
        if(SaveConfig()) pgPrint(0,0,RGB_BLUE,"Save Config file OK");
        else             pgPrint(0,0,RGB_RED ,"Save Config file NG");
        pgScreenFlipV();
    }*/
      

    // NbNύX
    changeClock();
    
    // ʂ^ɂ
    CLS(0);

#ifdef SOUND
    enable_sound(eConf.sound);
#endif

    image_config_update();

    return retcode;
}
